
// Copyright  2002-2010 Luigi Pino. All Rights Reserved.

/***************************************************************************/

#ifndef _NEUROSIS_ENGINE_PHYSICS_H_
#define _NEUROSIS_ENGINE_PHYSICS_H_

/***************************************************************************/

//! Object1 vertices vs. object2 faces.
//! To check all object2 faces, set iMesh == -1.
//! Returns averaged collision point (0.0f, 0.0f, 0.0f if none).
float3	Collision_Object_VS_Object(CModel *object1, CModel *object2, int iMesh);

//!	Sphere vs. object - to check all the faces of object, set iMesh == -1.
//! Buffer collision moves sphere to avoid sticking.
bool		Collision_Sphere_VS_Object(CModel *sphere, CModel *object, int iMesh, bool react, bool bufferCollision);

//!	Sphere vs. object - to check all the faces of object, set iMesh == -1.
//!	Will only use points that are <= 0.1f for calculations.
//! Buffer collision moves sphere to avoid sticking.
bool		Collision_Sphere_VS_Object_2D(CModel *sphere, CModel *object, int iMesh, bool react, bool bufferCollision);

//!	Sphere vs. sphere
bool		Collision_Sphere_VS_Sphere(CModel *sphere1, CModel *sphere2, bool react);

/***************************************************************************/
#endif